﻿using System;
using VA.TMP.Integration.VIMT.HealthShare.Mappers;
using VA.TMP.Integration.VIMT.HealthShare.StateObject;
using VA.TMP.Integration.VIMT.Messages.HealthShare;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.HealthShare.PipelineSteps.GetConsults
{
    /// <summary>
    /// Map Consult EC to LOB step.
    /// </summary>
    public class MapConsultsResponseStep : FilterBase<GetConsultsStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(GetConsultsStateObject state)
        {
            try
            {
                var mapper = new GetConsultsEcLobMapper();

                if (!string.IsNullOrEmpty(state.ConsultsFakeResponseType))
                {
                    const string message = "*****THIS IS FAKE DATA. DATA NOT SENT TO HEALTHSHARE*****";

                    if (state.PatEcResponseMessage != null) state.ResponseMessage = mapper.Map(state.PatEcResponseMessage, true, state.ResponseMessage);
                    if (state.ProEcResponseMessage != null) state.ResponseMessage = mapper.Map(state.ProEcResponseMessage, false, state.ResponseMessage);

                    state.ResponseMessage.ExceptionMessage = message;
                    state.ResponseMessage.ExceptionOccured = false;
                }
                else
                {
                    if (state.ExceptionOccured)
                    {
                        state.ResponseMessage = new TmpHealthShareGetConsultsResponse
                        {
                            ExceptionOccured = true,
                            ExceptionMessage = state.ExceptionMessage,
                            EcProcessingMs = state.EcProcessingTimeMs
                        };
                    }
                    else
                    {
                        if (state.PatEcResponseMessage != null) state.ResponseMessage = mapper.Map(state.PatEcResponseMessage, true, state.ResponseMessage);
                        if (state.ProEcResponseMessage != null) state.ResponseMessage = mapper.Map(state.ProEcResponseMessage, false, state.ResponseMessage);

                        state.ResponseMessage.ExceptionMessage = string.Empty;
                        state.ResponseMessage.ExceptionOccured = false;
                        state.ResponseMessage.EcProcessingMs = state.EcProcessingTimeMs;
                    }
                }
            }
            catch (Exception ex)
            {
                throw new Exception($"HealthShare Get Consults MapConsultsResponseStep Pipeline Error: {ex.Message}", ex.InnerException);
            }
        }
    }
}